      *  Basic demonstration of SSL programming from ILE RPG
      *  This example connects to my web server at www.klements.com
      *  using an SSL session, and asks that server if it detects
      *  me running SSL.
      *                                   Scott Klement, Sept 2006
      *
      *  To Compile:
      *    Make sure the SOCKET_H and GSKSSL_H members have been
      *    uploaded and are in a QRPGLESRC file in your library list.
      *    then:
      *    CRTBNDRPG PGM(SSLCHECK) SRCFILE(xx/QRPGLESRC) DBGVIEW(*LIST)
      *
     H DFTACTGRP(*NO) BNDDIR('QC2LE')

      /copy socket_h
      /copy gskssl_h

     D QDCXLATE        PR                  ExtPgm('QDCXLATE')
     D   len                          5P 0 const
     D   string                   32702A   options(*varsize)
     D   table                       10A   const

     D CreateEnv       PR                  like(gsk_handle)
     D ConnSock        PR            10I 0
     d   host                       256A   const
     D   port                        10I 0 value
     D UpgradeSock     PR                  like(gsk_handle)
     D    SslEnv                           like(gsk_handle) value
     D    sock                       10I 0 value
     D CloseSsl        PR
     D    Handle                           like(gsk_handle) value
     D CloseSslEnv     PR
     D    SslEnv                           like(gsk_handle) value
     D ReportError     PR
     D EscapeMsg       PR
     D errMsg          s             80A   varying

     D CRLF            c                   x'0d25'
     D env             s                   like(gsk_handle)
     D s               s             10I 0
     D connto          ds                  likeds(sockaddr_in)
     D SslSock         s                   like(gsk_handle)
     D cmd             s            400A
     D len             s             10I 0
     D bytesSent       s             10I 0
     D Reply           s           1000A
     D bytesRead       s             10I 0
     D left            s             10I 0
     D buf             s               *
     D received        s             10I 0
     D dataPos         s             10I 0
     D msg             s             50a
     D wait            s              1A
     D rc              s             10I 0


      /free

         // Create an SSL environment

         env = CreateEnv();
         if (env = *NULL);
            EscapeMsg();
         endif;

         // Connect a socket to an SSL server (using normal socket
         //  calls )

         s = ConnSock('www.klements.com': 443);

         // Upgrade the socket to SSL

         SSLSock = UpgradeSock(env: s);
         if (SSLSock = *NULL);
            EscapeMsg();
         endif;

         // Data is sent/received using the followig APIs:
         //    gsk_secure_soc_write()
         //    gsk_secure_soc_read()

         cmd = 'GET /cgi-bin/ssltest HTTP/1.0' + CRLF
             + 'Host: www.klements.com' + CRLF
             + 'Connection: close' + CRLF
             + CRLF;
         len = %len(%trimr(cmd));

         QDCXLATE( len
                 : cmd
                 : 'QTCPASC' );

         callp gsk_secure_soc_write( SSLSock
                                   : %addr(cmd)
                                   : len
                                   : bytesSent );

         Reply = *blanks;
         left = %size(Reply);
         buf = %addr(reply);
         received = 0;

         // keep reading until we get the entire response

         dou (rc <> GSK_OK);

             rc = gsk_secure_soc_read( SSLSock
                                     : buf
                                     : left
                                     : bytesRead );
             if (rc = GSK_OK);
                  received = received + bytesRead;
                  buf = buf + bytesRead;
                  left = left - bytesRead;
             endif;
         enddo;

         QDCXLATE( received
                 : reply
                 : 'QTCPEBC' );

         // The particular CGI program I've called will return a
         // sentence telling me if I'm running SSL or not.  Strip
         // off the HTTP headers and display that response:

         datapos = %scan(CRLF+CRLF: reply) + 4;
         len = %scan(CRLF:reply:datapos) - datapos;
         msg  = %subst(reply: datapos: len);
         dsply msg ' ' wait;

         // Close everything and end the prgoram.

         CloseSsl(SslSock);
         CloseSslEnv(Env);

         *inlr = *on;
      /end-free


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * CreateEnv(): Create an SSL environment for client sockets
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P CreateEnv       B
     D CreateEnv       PI                  like(gsk_handle)
     D rc              s             10I 0
     D SslEnv          s                   like(Gsk_handle)
      /free

        // Create an SSL environment with default values:

         rc = gsk_environment_open(SslEnv);
         if (rc <> GSK_OK);
            errMsg = %str(gsk_strerror(rc));
            return *NULL;
         endif;

        // Tell the environment to use the *SYSTEM certificate
        //  store

         rc = gsk_attribute_set_buffer( SslEnv
                                      : GSK_KEYRING_FILE
                                      : '*SYSTEM'
                                      : 0 );
         if (rc <> GSK_OK);
            errMsg = %str(gsk_strerror(rc));
            gsk_environment_close( SslEnv );
            return *NULL;
         endif;

        // Tell the environment that this is a client connection

         rc = gsk_attribute_set_enum( SslEnv
                                    : GSK_SESSION_TYPE
                                    : GSK_CLIENT_SESSION );
         if (rc <> GSK_OK);
            errMsg = %str(gsk_strerror(rc));
            gsk_environment_close( SslEnv );
            return *NULL;
         endif;

        // Activate the new environment.

         rc = gsk_environment_init( SslEnv );
         if (rc <> GSK_OK);
            errMsg = %str(gsk_strerror(rc));
            gsk_environment_close( SslEnv );
            return *NULL;
         endif;

         return SslEnv;
      /end-free
     P                 E

      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * ConnSock(): Create a TCP Socket and connect to a host
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P ConnSock        B
     D ConnSock        PI            10I 0
     d   host                       256A   const
     D   port                        10I 0 value
     D s               s             10I 0
     D addr            s             10U 0
      /free

         // look up host

         addr = inet_addr(%trim(host));
         if (addr = INADDR_NONE);
             p_hostent = gethostbyname(%trim(host));
             if (p_hostent = *NULL);
                 errMsg = 'Host not found!';
                 EscapeMsg();
             endif;
             addr = h_addr;
         endif;

         // Create a socket

         s = socket(AF_INET: SOCK_STREAM: IPPROTO_IP);
         if (s < 0);
            ReportError();
         endif;

         // connect to the host

         connto = *ALLx'00';
         connto.sin_family = AF_INET;
         connto.sin_addr   = addr;
         connto.sin_port   = port;

         if (connect(s: %addr(Connto): %size(connto)) = -1);
            callp close(S);
            ReportError();
         endif;

         return s;
      /end-free
     P                 E


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * UpgradeSock():  Upgrade a socket to use SSL
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P UpgradeSock     B
     D UpgradeSock     PI                  like(gsk_handle)
     D    SslEnv                           like(gsk_handle) value
     D    sock                       10I 0 value
     D Handle          s                   like(Gsk_handle)
      /free
          rc = gsk_secure_soc_open(SslEnv: Handle);
          if (rc <> GSK_OK);
             errMsg = %str(gsk_strerror(rc));
             return *NULL;
          endif;

          rc = gsk_attribute_set_numeric_value( Handle
                                              : GSK_HANDSHAKE_TIMEOUT
                                              : 30 );
          if (rc <> GSK_OK);
             errMsg = %str(gsk_strerror(rc));
             gsk_secure_soc_close(Handle);
             return *NULL;
          endif;

          rc = gsk_attribute_set_numeric_value( Handle
                                              : GSK_FD
                                              : sock );
          if (rc <> GSK_OK);
             errMsg = %str(gsk_strerror(rc));
             gsk_secure_soc_close(Handle);
             return *NULL;
          endif;

          rc = gsk_secure_soc_init( Handle );
          if (rc <> GSK_OK);
             errMsg = %str(gsk_strerror(rc));
             gsk_secure_soc_close(Handle);
             return *NULL;
          endif;

          return Handle;
      /end-free
     P                 E


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * CloseSsl():  Close an SSL socket
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P CloseSsl        B
     D CloseSsl        PI
     D    Handle                           like(gsk_handle) value
      /free
           gsk_secure_Soc_close( handle);
      /end-free
     P                 E


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * CloseSslEnv():  Close SSL Environment
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P CloseSslEnv     B
     D CloseSslEnv     PI
     D    SslEnv                           like(gsk_handle) value
      /free
           gsk_environment_close( SslEnv );
      /end-free
     P                 E


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * EscapeMsg(): Send an escape message w/reason for SSL failure
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P EscapeMsg       B
     D EscapeMsg       PI

     D SndPgmMsg       PR                  ExtPgm('QMHSNDPM')
     D   MessageID                    7A   Const
     D   QualMsgF                    20A   Const
     D   MsgData                    256A   Const
     D   MsgDtaLen                   10I 0 Const
     D   MsgType                     10A   Const
     D   CallStkEnt                  10A   Const
     D   CallStkCnt                  10I 0 Const
     D   MessageKey                   4A
     D   ErrorCode                    1A

     D ErrorCode       DS
     D  BytesProv                    10I 0 inz(0)
     D  BytesAvail                   10I 0 inz(0)

     D wwTheKey        S              4A
      /free

           SndPgmMsg( 'CPF9897'
                    : 'QCPFMSG   *LIBL'
                    : errMsg
                    : %len(%trimr(errMsg))
                    : '*ESCAPE'
                    : '*CTLBDY'
                    : 1
                    : wwTheKey
                    : ErrorCode );

      /end-free
     P                 E


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * ReportError():  Send an escape message explaining any errors
      *                 that occurred.
      *
      *  This function requires binding directory QC2LE in order
      *  to access the __errno() function.
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P ReportError     B
     D ReportError     PI

     D get_errno       PR              *   ExtProc('__errno')
     D ptrToErrno      s               *
     D errno           s             10I 0 based(ptrToErrno)

     D QMHSNDPM        PR                  ExtPgm('QMHSNDPM')
     D   MessageID                    7A   Const
     D   QualMsgF                    20A   Const
     D   MsgData                      1A   Const
     D   MsgDtaLen                   10I 0 Const
     D   MsgType                     10A   Const
     D   CallStkEnt                  10A   Const
     D   CallStkCnt                  10I 0 Const
     D   MessageKey                   4A
     D   ErrorCode                 8192A   options(*varsize)

     D ErrorCode       DS                  qualified
     D  BytesProv              1      4I 0 inz(0)
     D  BytesAvail             5      8I 0 inz(0)

     D MsgKey          S              4A
     D MsgID           s              7A

      /free

         ptrToErrno = get_errno();
         MsgID = 'CPE' + %char(errno);

         QMHSNDPM( MsgID
                 : 'QCPFMSG   *LIBL'
                 : ' '
                 : 0
                 : '*ESCAPE'
                 : '*PGMBDY'
                 : 1
                 : MsgKey
                 : ErrorCode         );

      /end-free
     P                 E
